'-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'Program written by Joel Bowman and Bradley Jones
'-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'This is the main program for the estimates discussed in Jones and Bowman (2019), "China's Evolving Monetary Policy Framework in International Context".
'This program sets up the Eviews workfile and reads in the data. 
'See readme.docx for more details
'-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'---------------------
'	Model inputs 
'----------------------
'Please save a copy of Eviews_data.xlsx and include a link to this saved file in the line below (e.g. "C:\Eviews_data.xlsx")
wfopen "Eviews_data.xlsx" range="eviews"

'Transform variables into logs and log differences
for %h crb ind_prod cpi credit m2 nomtwi hp mb cpi_nofood tsf mb_sa
	genr l_{%h} = log({%h})
	genr dl_{%h} = d(l_{%h})*100
next

'----------------------------------
'	Structural VAR models 
'----------------------------------
'Baseline
var var_base.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_base.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_base.append(svar) @diag(b)
var_base.svar
var_base.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'Baseline - Split Sample
smpl 1997m1 2008m12
var var_basepre08.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_basepre08.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_basepre08.append(svar) @diag(b)
var_basepre08.svar
var_basepre08.impulse(24,a, m, imp=struct, se=mc, rep=1000)
smpl @all
smpl 2009m1 @last
var var_basepost08.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_basepost08.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_basepost08.append(svar) @diag(b)
var_basepost08.svar
var_basepost08.impulse(24,a, m, imp=struct, se=mc, rep=1000)
smpl @all

'Government Bond Yields (2002-2009)
for %a gov1 gov5 gov10
	smpl 2002m1 2009m12
	var var_pre10yr_{%a}.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 {%a} dl_crb dl_nomtwi 
	var_pre10yr_{%a}.append(svar) @vec(a) = 1, na, na, na, 0, na, na, na, 0, 1, na, na, 0, na, na, na, 0, 0, 1, na, 0, na, na, na, 0, 0, 0, 1, 0, na, na, na, 0, 0, na, na, 1, na, na, na, 0, 0, 0, 0, 0, 1, na, na, 0, 0, 0, 0, na, 0, 1, na, 0, 0, 0, 0, na, 0, 0, 1
	var_pre10yr_{%a}.append(svar) @diag(b)
	var_pre10yr_{%a}.svar
	var_pre10yr_{%a}.impulse(24,m, imp=struct, se=mc, rep=1000) {%a} dl_m2 r007 @ dl_m2 r007
next
smpl @all

'Government Bond Yields (2010-2018)
for %a gov1 gov5 gov10
	smpl 2010m1 @last
	var var_post10yr_{%a}.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 {%a} dl_crb dl_nomtwi 
	var_post10yr_{%a}.append(svar) @vec(a) = 1, na, na, na, 0, na, na, na, 0, 1, na, na, 0, na, na, na, 0, 0, 1, na, 0, na, na, na, 0, 0, 0, 1, 0, na, na, na, 0, 0, na, na, 1, na, na, na, 0, 0, 0, 0, 0, 1, na, na, 0, 0, 0, 0, na, 0, 1, na, 0, 0, 0, 0, na, 0, 0, 1
	var_post10yr_{%a}.append(svar) @diag(b)
	var_post10yr_{%a}.svar
	var_post10yr_{%a}.impulse(24, m, imp=struct, se=mc, rep=1000) {%a} dl_m2 r007 @ dl_m2 r007
next
smpl @all

'House prices
var var_hp.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_hp dl_crb dl_nomtwi
var_hp.append(svar) @vec(a) = 1, na, na, na, 0, na, na, na, 0, 1, na, na, 0, na, na, na, 0, 0, 1, na, 0, na, na, na, 0, 0, 0, 1, 0, na, na, na, 0, 0, na, na, 1, na, na, na, 0, 0, 0, 0, 0, 1, na, na, 0, 0, 0, 0, na, 0, 1, na, 0, 0, 0, 0, na, 0, 0, 1
var_hp.append(svar) @diag(b)
var_hp.svar
var_hp.impulse(24,a, m, imp=struct, se=mc, rep=1000) dl_hp @ dl_m2 r007

'-----------------------------------------------------------------
'	Structural VAR models - Robustness Checks
'-----------------------------------------------------------------

'Chelosky assumption
var var_ext_chol_base.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_ext_chol_base.append(svar) @unitlower(a) 
var_ext_chol_base.append(svar) @diag(b)
var_ext_chol_base.svar
var_ext_chol_base.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'Additional Lag
var var_ext_lag_base.ls 1 3 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_ext_lag_base.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_ext_lag_base.append(svar) @diag(b)
var_ext_lag_base.svar
var_ext_lag_base.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'Controls for the global financial crisis
genr fin_crisis = 0
smpl 2008m9 2009m8
series fin_crisis = 1
smpl @all
var var_ext_fincrisis_base.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi @ c fin_crisis
var_ext_fincrisis_base.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_ext_fincrisis_base.append(svar) @diag(b)
var_ext_fincrisis_base.svar
var_ext_fincrisis_base.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'Replacing credit with Total Social Financing
var var_tsf.ls 1 2 dl_ind_prod dl_cpi dl_tsf dl_m2 r007 dl_crb dl_nomtwi
var_tsf.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_tsf.append(svar) @diag(b)
var_tsf.svar
var_tsf.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'Replacing CPI with the quarterly GDP deflator (linearly interporlated)
var var_gdpdeflator.ls 1 2 dl_ind_prod gdpdeflator dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_gdpdeflator.append(svar) @vec(a) = 1, na, na, na, 0, na, na, 0, 1, na, na, 0, na, na, 0, 0, 1, na, 0, na, na, 0, 0, 0, 1, 0, na, na, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, na, 0, 1
var_gdpdeflator.append(svar) @diag(b)
var_gdpdeflator.svar
var_gdpdeflator.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'The addition of base money and benchmark lending rates
var var_full_sa_mb.ls 1 2 dl_ind_prod dl_cpi dl_credit dl_m2 dl_mb_sa bench r007 dl_crb dl_nomtwi
var_full_sa_mb.append(svar) @vec(a) = 1, na, na, na, 0, 0, 0, na, na, 0, 1, na, na, 0, 0, 0, na, na, 0, 0, 1, na, 0, 0, 0, na,na, 0,	0, 0, 1, 0, 0, 0, na, na, 0, 0, 0, 0, 1, 0, na, na, na, 0, 0, na, na, 0, 1, na, na, na, 0,0, na, na, na, 0, 1, na, na, 0, 0, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, 0, 0, 0, 0, 1
var_full_sa_mb.append(svar) @diag(b)
var_full_sa_mb.svar
var_full_sa_mb.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'The addition of montly fiscal expenditure
var var_fiscal.ls 1 2 dl_ind_prod dl_cpi fiscal dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_fiscal.append(svar) @vec(a) = 1, na, na, na, na, 0, na, na, 0, 1, na, na, na, 0, na, na, 0, 0, 1, na, na, 0, na, na, 0, 0, 0, 1, na, 0, na, na, 0, 0, 0, 0, 1, 0, na, na, 0, 0, 0, na, na, 1, na, na, 0, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, 0, na, 0, 1
var_fiscal.append(svar) @diag(b)
var_fiscal.svar
var_fiscal.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'The additional of the federal funds rate
var var_fedfunds.ls 1 2 fedfunds dl_ind_prod dl_cpi dl_credit dl_m2 r007 dl_crb dl_nomtwi
var_fedfunds.append(svar) @vec(a) = 1, na, na, na, na, na, na, na, 0, 1, na, na, na, 0, na, na, 0, 0, 1, na, na, 0, na, na, 0, 0, 0, 1, na, 0, na, na, 0, 0, 0, 0, 1, 0, na, na, 0, 0, 0, na, na, 1, na, na,	0, 0, 0, 0, 0, na, 1, na, 0, 0, 0, 0, 0, na, 0, 1
var_fedfunds.append(svar) @diag(b)
var_fedfunds.svar
var_fedfunds.impulse(24,a, m, imp=struct, se=mc, rep=1000)

'-----------------------------------------------------------------
'	PROGRAM END
'-----------------------------------------------------------------


